﻿;/////////////////////////////////////////////////////////////////////////////////
;Demo of the OOP class for implementing a menu color picker.

;By Stephen Rodriguez.

;Demonstrates some of the methods exposed by the 'MenuColorPickerObject' class.
;/////////////////////////////////////////////////////////////////////////////////

XIncludeFile "menuColorPickerClass.pbi"


;Our user-defined menu color picker callback.
  Procedure Callback(row, column, selectedItem, color)
    Debug "Hovering over color $" + RSet(Hex(color, #PB_Long), 8, "0")
  EndProcedure


;Create a menu color picker object.
  MyMenuColorPickerObject.MenuColorPickerObject
  MyMenuColorPickerObject = NewMenuColorPicker()

If MyMenuColorPickerObject
  ;Add some standard menu items. We must do this immediately after creating the object.
    MenuItem(1, "New")
    MenuBar()
    OpenSubMenu("File")
      MenuItem(2, "&Open" + Chr(9) + "Ctrl O")
      MenuItem(3, "&Close")
    CloseSubMenu()
    MenuBar()
  ;Add the colors. (This library will prevent you from placing the color items in a submenu.)
    MyMenuColorPickerObject\AddColors()
    MenuBar()
    MenuItem(4, "Exit")

  ;Set a user callback to receive notifications whilst the user is navigating the colors. This is of course optional.
    MyMenuColorPickerObject\SetUserCallback(@Callback())

  ;Open a window ready to diplay the color picker.
    If OpenWindow(0, 200, 200, 400, 400, "MenuColourPicker class demo")

      Repeat
        Select WaitWindowEvent()
          Case #WM_RBUTTONDOWN
            color.q = MyMenuColorPickerObject\DisplayColorPicker(WindowID(0))
            Debug "=============================================="
            If color = -1
              Debug "Cancelled!"
              MyMenuColorPickerObject\SetDefaultColor(-1) ;In case a subsequent call uses the 'More colors...' option.
            ElseIf color&$ffffffff00000000
              color = color>>32
              Debug "Selected menu item " + Str(color)
            Else
              Debug "Selected colour = $" + RSet(Hex(color, #PB_Long), 8, "0")
              MyMenuColorPickerObject\SetDefaultColor(color)  ;In case a subsequent call uses the 'More colors...' option.
            EndIf
          Case #PB_Event_CloseWindow
            Quit = 1
        EndSelect
      Until Quit = 1
    EndIf

  ;Destroy the object when no longer required.
    MyMenuColorPickerObject\Destroy()
Else
  MessageRequester("Error :", "There was a memory allocation problem creating the menu color picker object.")
EndIf
  


; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 56
; FirstLine = 22
; Folding = -
; EnableAsm
; EnableUnicode
; EnableXP